<style>
	#actualtopics .display-style-icon .lfr-asset-item{
		width: 33%;
		padding-left: 9px;
		padding-right: 9px;   
	}
	
	#actualtopics .aspect-ratio{
		position:relative;
	}
	
	
	#actualtopics .entryTitleText{
		font-family:Arial, Helvetica, sans-serif;
        font-size:16px; 
		text-align: center;

		display:block;
		position:absolute;
		left:0;
		bottom:0;
		width:100%;
		box-sizing:border-box;
		-moz-box-sizing: border-box;
		-webkit-box-sizing: border-box;
		box-sizing: border-box; 
		color:#fff;
		padding:2px 5% 2px 5%;
		background-color:rgba(0,0,0,.4);
	}
	
	#actualtopics .editIcon{
		display:block;
		position:absolute;
		left:0;
		top:0;
		width:20%;
	}
	
	#actualtopics .editIcon:hover{
		background-color: red;
	}
	
	#actualtopics .empty{
		display:block;
		position:absolute;
		left:0;
		bottom: 0;
		width: 100%;
		height: 140px;
		z-index: 0;
	}
</style>

<div id="actualtopics">
	<ul class="display-style-icon list-unstyled row" data-qa-id="rows0">
		<#if entries?has_content>
			<#list entries as entry>
			
				<#assign
					entry = entry
					entryId = entry.getEntryId()
					assetRenderer = entry.getAssetRenderer()
					entryTitle = htmlUtil.escape(assetRenderer.getTitle(locale))
				/>
				<#assign docXml = saxReaderUtil.read(entry.getAssetRenderer().getArticle().getContent()) />
				<#assign ddmimg = docXml.valueOf("//dynamic-element[@name='ddmimg']/dynamic-content/text()") />
				<#assign readmore = docXml.valueOf("//dynamic-element[@name='readmore']/dynamic-content/text()") />
				
				<#list readmore?split("@") as item>
					<#if item_index == 0>
						<#assign linkPageId = item?number>
					</#if>
					<#if item_index == 1>
						<#if item == "private">
							<#assign linkPrivate = true>
						<#else>
							<#assign linkPrivate = false>
						</#if>
					</#if>
					<#if item_index = 2>
						<#assign linkGroupId = item?number>
					</#if>
				</#list>
				
				<#assign LayoutLocalService = serviceLocator.findService("com.liferay.portal.kernel.service.LayoutLocalService")>
				
				
				<#assign pageLayout = LayoutLocalService.getLayout(linkGroupId, linkPrivate, linkPageId)>
				<#assign friendly_page_link = portalUtil.getLayoutFriendlyURL(pageLayout, themeDisplay)>
					<li class="lfr-asset-item">
						<div>
							<div class="card">
								<div class="aspect-ratio aspect-ratio-bg-cover" style="background-image: url('${ddmimg}&imagePreview=1')">
									<div class="editIcon">
										<span><@getEditIcon /></span>
									</div>
									<a href="${friendly_page_link}">
										<div class="empty">
										</div>
										<div class="entryTitleText">
											<span>${entryTitle}</span>
										</div>
									</a>
								</div>
							</div>
						</div>
					</li>
		
			</#list>
		</#if>
		
		<li></li>
	</ul>
</div>


<#macro getEditIcon>
	<#if assetRenderer.hasEditPermission(themeDisplay.getPermissionChecker())>
		<#assign redirectURL = renderResponse.createRenderURL() />
		${redirectURL.setParameter("mvcPath", "/add_asset_redirect.jsp")}
		${redirectURL.setWindowState("pop_up")}
		<#assign editPortletURL = assetRenderer.getURLEdit(renderRequest, renderResponse, windowStateFactory.getWindowState("pop_up"), redirectURL)!"" />
		<#if validator.isNotNull(editPortletURL)>
			<#assign title = languageUtil.format(locale, "edit-x", entryTitle, false) />
			<@liferay_ui["icon"]
				iconCssClass="icon-edit-sign"
				message=title
				url="javascript:Liferay.Util.openWindow({id:'" + renderResponse.getNamespace() + "editAsset', title: '" + title + "', uri:'" + htmlUtil.escapeURL(editPortletURL.toString()) + "'});"
			/>
		</#if>
	</#if>
</#macro>